/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public class ConcurrentLinkedDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    private void linkFirst(E e) {
        Node node;
        Node node2;
        ConcurrentLinkedDeque.checkNotNull(e);
        Node node3 = new Node(e);
        block0: while (true) {
            node = node2 = this.head;
            while (true) {
                Node node4;
                if ((node4 = node.prev) != null) {
                    node = node4;
                    node4 = node.prev;
                    if (node4 != null) {
                        node = node2 != (node2 = this.head) ? node2 : node4;
                        continue;
                    }
                }
                if (node.next == node) continue block0;
                node3.lazySetNext(node);
                if (node.casPrev(null, node3)) break block0;
            }
            break;
        }
        if (node != node2) {
            this.casHead(node2, node3);
        }
    }

    private void linkLast(E e) {
        Node node;
        Node node2;
        ConcurrentLinkedDeque.checkNotNull(e);
        Node node3 = new Node(e);
        block0: while (true) {
            node = node2 = this.tail;
            while (true) {
                Node node4;
                if ((node4 = node.next) != null) {
                    node = node4;
                    node4 = node.next;
                    if (node4 != null) {
                        node = node2 != (node2 = this.tail) ? node2 : node4;
                        continue;
                    }
                }
                if (node.prev == node) continue block0;
                node3.lazySetPrev(node);
                if (node.casNext(null, node3)) break block0;
            }
            break;
        }
        if (node != node2) {
            this.casTail(node2, node3);
        }
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst(node, node3);
        } else if (node3 == null) {
            this.unlinkLast(node, node2);
        } else {
            boolean bl;
            Node node4;
            Node node5;
            boolean bl2;
            Node node6;
            int n = 1;
            Node node7 = node2;
            while (true) {
                if (node7.item != null) {
                    node6 = node7;
                    bl2 = false;
                    break;
                }
                node5 = node7.prev;
                if (node5 == null) {
                    if (node7.next == node7) {
                        return;
                    }
                    node6 = node7;
                    bl2 = true;
                    break;
                }
                if (node7 == node5) {
                    return;
                }
                node7 = node5;
                ++n;
            }
            node7 = node3;
            while (true) {
                if (node7.item != null) {
                    node4 = node7;
                    bl = false;
                    break;
                }
                node5 = node7.next;
                if (node5 == null) {
                    if (node7.prev == node7) {
                        return;
                    }
                    node4 = node7;
                    bl = true;
                    break;
                }
                if (node7 == node5) {
                    return;
                }
                node7 = node5;
                ++n;
            }
            if (n < 2 && bl2 | bl) {
                return;
            }
            this.skipDeletedSuccessors(node6);
            this.skipDeletedPredecessors(node4);
            if (bl2 | bl && node6.next == node4 && node4.prev == node6 && (bl2 ? node6.prev == null : node6.item != null) && (bl ? node4.next == null : node4.item != null)) {
                this.updateHead();
                this.updateTail();
                node.lazySetPrev(bl2 ? this.prevTerminator() : node);
                node.lazySetNext(bl ? this.nextTerminator() : node);
            }
        }
    }

    private void unlinkFirst(Node<E> node, Node<E> node2) {
        Node<E> node3 = null;
        Node<E> node4 = node2;
        while (true) {
            Node node5;
            if (node4.item != null || (node5 = node4.next) == null) {
                if (node3 != null && node4.prev != node4 && node.casNext(node2, node4)) {
                    this.skipDeletedPredecessors(node4);
                    if (node.prev == null && (node4.next == null || node4.item != null) && node4.prev == node) {
                        this.updateHead();
                        this.updateTail();
                        node3.lazySetNext(node3);
                        node3.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (node4 == node5) {
                return;
            }
            node3 = node4;
            node4 = node5;
        }
    }

    private void unlinkLast(Node<E> node, Node<E> node2) {
        Node<E> node3 = null;
        Node<E> node4 = node2;
        while (true) {
            Node node5;
            if (node4.item != null || (node5 = node4.prev) == null) {
                if (node3 != null && node4.next != node4 && node.casPrev(node2, node4)) {
                    this.skipDeletedSuccessors(node4);
                    if (node.next == null && (node4.prev == null || node4.item != null) && node4.next == node) {
                        this.updateHead();
                        this.updateTail();
                        node3.lazySetPrev(node3);
                        node3.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (node4 == node5) {
                return;
            }
            node3 = node4;
            node4 = node5;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateHead() {
        block0: while (true) {
            var1_1 = this.head;
            if (var1_1.item != null || (var2_2 = var1_1.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((var3_3 = var2_2.prev) == null) break block4;
                        var2_2 = var3_3;
                        var3_3 = var2_2.prev;
                        if (var3_3 != null) break block5;
                    }
                    if (!this.casHead(var1_1, var2_2)) continue block0;
                    return;
                }
                if (var1_1 == this.head) ** break;
                continue block0;
                var2_2 = var3_3;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTail() {
        block0: while (true) {
            var1_1 = this.tail;
            if (var1_1.item != null || (var2_2 = var1_1.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((var3_3 = var2_2.next) == null) break block4;
                        var2_2 = var3_3;
                        var3_3 = var2_2.next;
                        if (var3_3 != null) break block5;
                    }
                    if (!this.casTail(var1_1, var2_2)) continue block0;
                    return;
                }
                if (var1_1 == this.tail) ** break;
                continue block0;
                var2_2 = var3_3;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> node) {
        block0: do {
            Node node2;
            Node node3 = node2 = node.prev;
            while (node3.item == null) {
                Node node4 = node3.prev;
                if (node4 == null) {
                    if (node3.next != node3) break;
                    continue block0;
                }
                if (node3 == node4) continue block0;
                node3 = node4;
            }
            if (node2 != node3 && !node.casPrev(node2, node3)) continue;
            return;
        } while (node.item != null || node.next == null);
    }

    private void skipDeletedSuccessors(Node<E> node) {
        block0: do {
            Node node2;
            Node node3 = node2 = node.next;
            while (node3.item == null) {
                Node node4 = node3.next;
                if (node4 == null) {
                    if (node3.prev != node3) break;
                    continue block0;
                }
                if (node3 == node4) continue block0;
                node3 = node4;
            }
            if (node2 != node3 && !node.casNext(node2, node3)) continue;
            return;
        } while (node.item != null || node.prev == null);
    }

    final Node<E> succ(Node<E> node) {
        Node node2 = node.next;
        return node == node2 ? this.first() : node2;
    }

    final Node<E> pred(Node<E> node) {
        Node node2 = node.prev;
        return node == node2 ? this.last() : node2;
    }

    Node<E> first() {
        Node<E> node;
        Node<E> node2;
        block0: do {
            Node node3;
            node2 = node = this.head;
            while ((node3 = node2.prev) != null) {
                node2 = node3;
                node3 = node2.prev;
                if (node3 == null) continue block0;
                node2 = node != (node = this.head) ? node : node3;
            }
        } while (node2 != node && !this.casHead(node, node2));
        return node2;
    }

    Node<E> last() {
        Node<E> node;
        Node<E> node2;
        block0: do {
            Node node3;
            node2 = node = this.tail;
            while ((node3 = node2.next) != null) {
                node2 = node3;
                node3 = node2.next;
                if (node3 == null) continue block0;
                node2 = node != (node = this.tail) ? node : node3;
            }
        } while (node2 != node && !this.casTail(node, node2));
        return node2;
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    private ArrayList<E> toArrayList() {
        ArrayList arrayList = new ArrayList();
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                arrayList.add(e);
            }
            node = this.succ(node);
        }
        return arrayList;
    }

    public ConcurrentLinkedDeque() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedDeque(Collection<? extends E> collection) {
        Node<E> node = null;
        Node<E> node2 = null;
        for (E e : collection) {
            ConcurrentLinkedDeque.checkNotNull(e);
            Node<E> node3 = new Node<E>(e);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node3.lazySetPrev(node2);
            node2 = node3;
        }
        this.initHeadTail(node, node2);
    }

    private void initHeadTail(Node<E> node, Node<E> node2) {
        if (node == node2) {
            if (node == null) {
                node2 = new Node<Object>(null);
                node = node2;
            } else {
                Node<Object> node3 = new Node<Object>(null);
                node2.lazySetNext(node3);
                node3.lazySetPrev(node2);
                node2 = node3;
            }
        }
        this.head = node;
        this.tail = node2;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.linkFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                return e;
            }
            node = this.succ(node);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> node = this.last();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                return e;
            }
            node = this.pred(node);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<Object> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null && node.casItem(e, null)) {
                this.unlink(node);
                return e;
            }
            node = this.succ(node);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<Object> node = this.last();
        while (node != null) {
            Object e = node.item;
            if (e != null && node.casItem(e, null)) {
                this.unlink(node);
                return e;
            }
            node = this.pred(node);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        ConcurrentLinkedDeque.checkNotNull(object);
        Node<Object> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null && object.equals(e) && node.casItem(e, null)) {
                this.unlink(node);
                return true;
            }
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        ConcurrentLinkedDeque.checkNotNull(object);
        Node<Object> node = this.last();
        while (node != null) {
            Object e = node.item;
            if (e != null && object.equals(e) && node.casItem(e, null)) {
                this.unlink(node);
                return true;
            }
            node = this.pred(node);
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null && object.equals(e)) {
                return true;
            }
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    @Override
    public int size() {
        int n = 0;
        Node<E> node = this.first();
        while (node != null && (node.item == null || ++n != Integer.MAX_VALUE)) {
            node = this.succ(node);
        }
        return n;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Node<E> node;
        Node<E> node2;
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        Node<E> node3 = null;
        Node<E> node4 = null;
        for (Object object : collection) {
            ConcurrentLinkedDeque.checkNotNull(object);
            node2 = new Node<E>(object);
            if (node3 == null) {
                node3 = node4 = node2;
                continue;
            }
            node4.lazySetNext(node2);
            node2.lazySetPrev(node4);
            node4 = node2;
        }
        if (node3 == null) {
            return false;
        }
        block1: while (true) {
            Object object;
            node = this.tail;
            object = node;
            while (true) {
                if ((node2 = ((Node)object).next) != null) {
                    object = node2;
                    node2 = ((Node)object).next;
                    if (node2 != null) {
                        object = node != (node = this.tail) ? node : node2;
                        continue;
                    }
                }
                if (((Node)object).prev == object) continue block1;
                node3.lazySetPrev((Node<E>)object);
                if (((Node)object).casNext(null, node3)) break block1;
            }
            break;
        }
        if (!this.casTail(node, node4)) {
            node = this.tail;
            if (node4.next == null) {
                this.casTail(node, node4);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.toArrayList().toArray(TArray);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<E> node = this.first();
        while (node != null) {
            Object e = node.item;
            if (e != null) {
                objectOutputStream.writeObject(e);
            }
            node = this.succ(node);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        Node<Object> node = null;
        Node<Object> node2 = null;
        while ((object = objectInputStream.readObject()) != null) {
            Node<Object> node3 = new Node<Object>(object);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node3.lazySetPrev(node2);
            node2 = node3;
        }
        this.initHeadTail(node, node2);
    }

    private boolean casHead(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node, node2);
    }

    private boolean casTail(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node, node2);
    }

    static {
        ConcurrentLinkedDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        ConcurrentLinkedDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentLinkedDeque> clazz = ConcurrentLinkedDeque.class;
            headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("tail"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node node;
            this.lastRet = this.nextNode;
            Node node2 = node = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (node == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object e = node.item;
                if (e != null) {
                    this.nextNode = node;
                    this.nextItem = e;
                    break;
                }
                node = this.nextNode(node);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object e = this.nextItem;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            node.item = null;
            ConcurrentLinkedDeque.this.unlink(node);
            this.lastRet = null;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return ConcurrentLinkedDeque.this.pred(node);
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return ConcurrentLinkedDeque.this.succ(node);
        }
    }

    static final class Node<E> {
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long prevOffset;
        private static final long itemOffset;
        private static final long nextOffset;

        Node() {
        }

        Node(E e) {
            UNSAFE.putObject((Object)this, itemOffset, e);
        }

        boolean casItem(E e, E e2) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, e, e2);
        }

        void lazySetNext(Node<E> node) {
            UNSAFE.putOrderedObject(this, nextOffset, node);
        }

        boolean casNext(Node<E> node, Node<E> node2) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node, node2);
        }

        void lazySetPrev(Node<E> node) {
            UNSAFE.putOrderedObject(this, prevOffset, node);
        }

        boolean casPrev(Node<E> node, Node<E> node2) {
            return UNSAFE.compareAndSwapObject(this, prevOffset, node, node2);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> clazz = Node.class;
                prevOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("prev"));
                itemOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

