/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import sun.security.util.SecurityConstants;

public class MouseInfo {
    private MouseInfo() {
    }

    public static PointerInfo getPointerInfo() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.WATCH_MOUSE_PERMISSION);
        }
        Point point = new Point(0, 0);
        int n = Toolkit.getDefaultToolkit().getMouseInfoPeer().fillPointWithCoords(point);
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        PointerInfo pointerInfo = null;
        if (MouseInfo.areScreenDevicesIndependent(graphicsDeviceArray)) {
            pointerInfo = new PointerInfo(graphicsDeviceArray[n], point);
        } else {
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                pointerInfo = new PointerInfo(graphicsDeviceArray[i], point);
            }
        }
        return pointerInfo;
    }

    private static boolean areScreenDevicesIndependent(GraphicsDevice[] graphicsDeviceArray) {
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            Rectangle rectangle = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
            if (rectangle.x == 0 && rectangle.y == 0) continue;
            return false;
        }
        return true;
    }

    public static int getNumberOfButtons() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.mouse.numButtons");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        assert (false) : "awt.mouse.numButtons is not an integer property";
        return 0;
    }
}

