/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.io.DataInputStream;
import java.io.IOException;

public final class Field
extends FieldOrMethod {
    public Field(Field field) {
        super(field);
    }

    Field(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        super(dataInputStream, constantPool);
    }

    public Field(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (this.attributes[i].getTag() != 1) continue;
            return (ConstantValue)this.attributes[i];
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        string = string.equals("") ? "" : string + " ";
        String string2 = Utility.signatureToString(this.getSignature());
        String string3 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string + string2 + " " + string3);
        ConstantValue constantValue = this.getConstantValue();
        if (constantValue != null) {
            stringBuffer.append(" = " + constantValue);
        }
        for (int i = 0; i < this.attributes_count; ++i) {
            Attribute attribute = this.attributes[i];
            if (attribute instanceof ConstantValue) continue;
            stringBuffer.append(" [" + attribute.toString() + "]");
        }
        return stringBuffer.toString();
    }

    public final Field copy(ConstantPool constantPool) {
        return (Field)this.copy_(constantPool);
    }

    public Type getType() {
        return Type.getReturnType(this.getSignature());
    }
}

