/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.ParseException;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.PermissionImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.snmp.IPAcl.SimpleNode;
import com.sun.jmx.snmp.InetAddressAcl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

public class SnmpAcl
implements InetAddressAcl,
Serializable {
    private static final long serialVersionUID = -6702287103824397063L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable<InetAddress, Vector<String>> trapDestList;
    private Hashtable<InetAddress, Vector<String>> informDestList;
    private PrincipalImpl owner;

    public SnmpAcl(String string) throws UnknownHostException, IllegalArgumentException {
        this(string, null);
    }

    public SnmpAcl(String string, String string2) throws UnknownHostException, IllegalArgumentException {
        block4: {
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) break block4;
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "SnmpAcl(String,String)", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (string2 == null) {
            this.setDefaultFileName();
        } else {
            this.setAuthorizedListFile(string2);
        }
        this.readAuthorizedListFile();
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public Enumeration<String> communities() {
        HashSet<String> hashSet = new HashSet<String>();
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.acl.entries();
        while (stringArray.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)stringArray.nextElement();
            Enumeration<String> enumeration = aclEntryImpl.communities();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        stringArray = hashSet.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector.elements();
    }

    @Override
    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public static String getDefaultAclFileName() {
        String string = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.home")).append(string).append("lib").append(string).append("snmp.acl");
        return stringBuffer.toString();
    }

    public void setAuthorizedListFile(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (!file.isFile()) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "setAuthorizedListFile", "ACL file not found: " + string);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] " + "doesn't exist or is not a file, " + "no configuration loaded");
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorizedListFile();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    @Override
    public boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    @Override
    public boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    @Override
    public boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    @Override
    public boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    @Override
    public boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    @Override
    public Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    @Override
    public Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector<String> vector = null;
        vector = this.trapDestList.get(inetAddress);
        if (vector != null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getTrapCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getTrapCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    @Override
    public Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    @Override
    public Enumeration getInformCommunities(InetAddress inetAddress) {
        Vector<String> vector = null;
        vector = this.informDestList.get(inetAddress);
        if (vector != null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getInformCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getInformCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    private void readAuthorizedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "Got parsing exception", parseException);
                }
                throw new IllegalArgumentException(parseException.getMessage());
            }
            catch (Error error) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "Got unexpected error", error);
                }
                throw new IllegalArgumentException(error.getMessage());
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "===> " + aclEntryImpl.getPrincipal().toString());
                }
                Enumeration<Permission> enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = enumeration.nextElement();
                    if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) continue;
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefaultFileName() {
        try {
            this.setAuthorizedListFile(SnmpAcl.getDefaultAclFileName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

