/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.PerfLogger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class IcoEncoder
implements IconEncoder {
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(File[] fileArray, int[] nArray, int n, String string) {
        int n2;
        IcoImageEncoder[] icoImageEncoderArray = new IcoImageEncoder[n];
        int n3 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                PerfLogger.setTime("before ico creation for " + string);
                Image image = ImageLoader.getInstance().loadImage(fileArray[i].getPath());
                if (image != null) {
                    icoImageEncoderArray[n3] = new IcoImageEncoder(image, nArray[i]);
                    icoImageEncoderArray[n3].createBitmaps();
                    ++n3;
                }
                PerfLogger.setTime("after ico creation for " + string);
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        n = n3;
        int[] nArray2 = new int[6];
        nArray2[0] = 6 + 16 * n;
        for (int i = 1; i < n; ++i) {
            nArray2[i] = nArray2[i - 1] + 40 + icoImageEncoderArray[i - 1].getXorData().length + icoImageEncoderArray[i - 1].getAndData().length;
        }
        FilterOutputStream filterOutputStream = null;
        filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
        IcoStreamWriter icoStreamWriter = IcoEncoder.getIcoStreamWriter((BufferedOutputStream)filterOutputStream);
        icoStreamWriter.writeIcoHeader(n);
        for (n2 = 0; n2 < n; ++n2) {
            IcoEncoder.writeIconDirEntry(icoStreamWriter, icoImageEncoderArray[n2].getSize(), nArray2[n2]);
        }
        for (n2 = 0; n2 < n; ++n2) {
            IcoEncoder.writeInfoHeader(icoStreamWriter, icoImageEncoderArray[n2].getSize());
            filterOutputStream.write(icoImageEncoderArray[n2].getXorData());
            filterOutputStream.write(icoImageEncoderArray[n2].getAndData());
        }
        ((BufferedOutputStream)filterOutputStream).flush();
        Object var12_16 = null;
        if (filterOutputStream == null) return;
        try {
            filterOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        return;
        {
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                Object var12_17 = null;
                if (filterOutputStream == null) return;
                try {
                    filterOutputStream.close();
                    return;
                }
                catch (Exception exception) {
                    Trace.ignoredException(exception);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (filterOutputStream == null) throw throwable;
            try {
                filterOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
            throw throwable;
        }
    }

    private static void writeInfoHeader(IcoStreamWriter icoStreamWriter, int n) throws IOException {
        icoStreamWriter.writeDWord(40);
        icoStreamWriter.writeDWord(n);
        icoStreamWriter.writeDWord(2 * n);
        icoStreamWriter.writeWord(1);
        icoStreamWriter.writeWord(24);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
    }

    private static void writeIconDirEntry(IcoStreamWriter icoStreamWriter, int n, int n2) throws IOException {
        int n3 = IcoEncoder.getAndScanSize(n);
        int n4 = IcoEncoder.getXorScanSize(n);
        try {
            icoStreamWriter.write(n);
            icoStreamWriter.write(n);
            icoStreamWriter.write(0);
            icoStreamWriter.write(0);
            icoStreamWriter.writeWord(1);
            icoStreamWriter.writeWord(24);
            int n5 = n * n4 + n * n3 + 40;
            icoStreamWriter.writeDWord(n5);
            icoStreamWriter.writeDWord(n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static int getAndScanSize(int n) {
        int n2 = (n + 7) / 8;
        int n3 = 4 * ((n2 + 3) / 4);
        return n3;
    }

    private static int getXorScanSize(int n) {
        int n2 = n * 3;
        int n3 = 4 * ((n2 + 3) / 4);
        return n3;
    }

    private static IcoStreamWriter getIcoStreamWriter(BufferedOutputStream bufferedOutputStream) {
        return new IcoStreamWriter(bufferedOutputStream);
    }

    public static void printIconFile(File file) {
        Trace.println("Icon: " + file);
        try {
            int n;
            int n2;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[6];
            fileInputStream.read(byArray2);
            Trace.println("header: " + byArray2[0] + ", " + byArray2[1] + ", " + byArray2[2] + ", " + byArray2[3] + ", " + byArray2[4] + ", " + byArray2[5]);
            int n3 = byArray2[4];
            for (n2 = 0; n2 < n3; ++n2) {
                fileInputStream.read(byArray);
                Trace.println("Dir entry " + n2 + ": " + byArray[0] + ", " + byArray[1] + ", " + byArray[2] + ", " + byArray[3] + ", " + byArray[4] + ", " + byArray[5] + ", " + byArray[6] + ", " + byArray[7] + ", " + byArray[8] + ", " + byArray[9] + ", " + byArray[10] + ", " + byArray[11] + ", " + byArray[12] + ", " + byArray[13] + ", " + byArray[14] + ", " + byArray[15]);
            }
            n2 = 0;
            Trace.println("InfoHeader: ");
            byte[] byArray3 = new byte[40];
            fileInputStream.read(byArray3);
            for (n2 = 0; n2 < 40; ++n2) {
                Trace.print(byArray3[n2] + ",");
            }
            Trace.println("\n");
            Trace.println("the rest: ");
            while ((n = fileInputStream.read(byArray)) > 0) {
                Trace.println(" line " + n2++ + " : " + byArray[0] + ", " + byArray[1] + ", " + byArray[2] + ", " + byArray[3] + ", " + byArray[4] + ", " + byArray[5] + ", " + byArray[6] + ", " + byArray[7] + ", " + byArray[8] + ", " + byArray[9] + ", " + byArray[10] + ", " + byArray[11] + ", " + byArray[12] + ", " + byArray[13] + ", " + byArray[14] + ", " + byArray[15]);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private static class IcoImageEncoder {
        Image _awtImage;
        int _size;
        byte[] _andData;
        byte[] _xorData;

        public IcoImageEncoder(Image image, int n) {
            this._size = n;
            this._awtImage = image;
            this._andData = new byte[this._size * IcoEncoder.getAndScanSize(this._size)];
            this._xorData = new byte[this._size * IcoEncoder.getXorScanSize(this._size)];
        }

        private int getSize() {
            return this._size;
        }

        private byte[] getXorData() {
            return this._xorData;
        }

        private byte[] getAndData() {
            return this._andData;
        }

        private void createBitmaps() throws IOException {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this._size;
            int n6 = this._size;
            int n7 = IcoEncoder.getXorScanSize(this._size);
            int n8 = IcoEncoder.getAndScanSize(this._size);
            byte[] byArray = new byte[n6 * n7];
            byte[] byArray2 = new byte[n6 * n8];
            BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(this._awtImage, 0, 0, n5, n6, 0, 0, this._awtImage.getWidth(null), this._awtImage.getHeight(null), null);
            graphics2D.dispose();
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = n4 * n8;
                n2 = 0;
                n = n4 * n7;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n12 = n4 * n5 + i;
                    int n13 = nArray[n12] >> 24 & 0xFF;
                    int n14 = nArray[n12] >> 16 & 0xFF;
                    int n15 = nArray[n12] >> 8 & 0xFF;
                    int n16 = nArray[n12] & 0xFF;
                    if (n13 == 0) {
                        n10 = (byte)(n10 | 128 >> n11);
                    }
                    if (++n11 == 8 || i == n5 - 1) {
                        byArray2[n3 + n2++] = n10;
                        n10 = 0;
                        n11 = 0;
                    }
                    byArray[n + n9++] = (byte)n16;
                    byArray[n + n9++] = (byte)n15;
                    byArray[n + n9++] = (byte)n14;
                }
                while (n2 < n8) {
                    byArray2[n3 + n2++] = 0;
                }
                while (n9 < n7) {
                    byArray[n + n9++] = 0;
                }
            }
            for (n2 = 0; n2 < n6; ++n2) {
                n3 = n2 * n7;
                n4 = (n6 - n2 - 1) * n7;
                for (n = 0; n < n7; ++n) {
                    this._xorData[n3 + n] = byArray[n4 + n];
                }
                n3 = n2 * n8;
                n4 = (n6 - n2 - 1) * n8;
                for (n = 0; n < n8; ++n) {
                    this._andData[n3 + n] = byArray2[n4 + n];
                }
            }
        }
    }

    private static class IcoStreamWriter {
        BufferedOutputStream _bos;

        private IcoStreamWriter(BufferedOutputStream bufferedOutputStream) {
            this._bos = bufferedOutputStream;
        }

        private void writeIcoHeader(int n) throws IOException {
            try {
                this.writeWord(0);
                this.writeWord(1);
                this.writeWord(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void write(int n) throws IOException {
            this._bos.write(n);
        }

        public void writeWord(int n) throws IOException {
            this._bos.write(n & 0xFF);
            this._bos.write((n & 0xFF00) >> 8);
        }

        public void writeDWord(int n) throws IOException {
            this._bos.write(n & 0xFF);
            this._bos.write((n & 0xFF00) >> 8);
            this._bos.write((n & 0xFF0000) >> 16);
            this._bos.write((n & 0xFF000000) >> 24);
        }
    }
}

