/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.trace.Trace;
import java.net.URL;

public final class WMozillaAutoProxyHandler
extends AbstractAutoProxyHandler {
    protected String getBrowserSpecificAutoProxy() {
        return "function isInNet(ipaddr, pattern, maskstr) {\n    var ipPattern = /^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$/;\n    var test = ipaddr.match(ipPattern);\n    if (test == null) {\n        ipaddr = dnsResolve(ipaddr);\n        if (ipaddr == null)\n            return false;\n    } else if ((test[1] > 255) || (test[2] > 255) || \n               (test[3] > 255) || (test[4] > 255) ) {\n        return false;\n    }\n    var host = convert_addr(ipaddr);\n    var pat  = convert_addr(pattern);\n    var mask = convert_addr(maskstr);\n    return ((host & mask) == (pat & mask));\n    \n}\nfunction dnsResolve(host){\nif (typeof host != 'string' || dnsDomainLevels(host) != 3) return ''; \nfor (var i=0; i < host.length; i++) \nif ((host.charAt(i) < '0' || host.charAt(i) > '9') && host.charAt(i) != '.') return ''; \nreturn host; }";
    }

    public ProxyInfo[] getProxyInfo(URL uRL) {
        String string = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (Config.isJavaVersionAtLeast14()) {
                stringBuffer.append(this.autoProxyScript);
            } else {
                stringBuffer.append(this.autoProxyScript.toString());
            }
            stringBuffer.append("FindProxyForURL('");
            stringBuffer.append(uRL);
            stringBuffer.append("','");
            stringBuffer.append(uRL.getHost());
            stringBuffer.append("');");
            string = this.evalScript(stringBuffer.toString());
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private native String evalScript(String var1);

    static {
        Platform.get().loadDeployNativeLib();
    }
}

