/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DeploymentHooks {
    static boolean usageTrackerFailed = false;
    Object usageTracker;
    Method runMethod;
    private static final String USAGE_TRACKER_APP_NAME_KEY = "UsageTracker-AppName";
    static /* synthetic */ Class class$java$lang$String;

    private boolean initialize() {
        if (usageTrackerFailed) {
            return false;
        }
        if (this.runMethod == null) {
            try {
                Class<?> clazz = Class.forName("sun.usagetracker.UsageTrackerClient", true, null);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.usageTracker = constructor.newInstance(new Object[0]);
                this.runMethod = clazz.getMethod("run", class$java$lang$String == null ? (class$java$lang$String = DeploymentHooks.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DeploymentHooks.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Throwable throwable) {
                usageTrackerFailed = true;
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAppName(String string) {
        System.setProperty(USAGE_TRACKER_APP_NAME_KEY, string);
    }

    private synchronized String getAndClearAppName() {
        String string = System.getProperty(USAGE_TRACKER_APP_NAME_KEY);
        System.clearProperty(USAGE_TRACKER_APP_NAME_KEY);
        return string;
    }

    public synchronized void trackUsage(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        if (!this.initialize()) {
            return;
        }
        String string = this.getAndClearAppName();
        if (string == null) {
            return;
        }
        try {
            Object[] objectArray;
            String string2 = null;
            if (Environment.isOldPlugin()) {
                string2 = "plugin";
            } else if (Environment.isJavaPlugin()) {
                string2 = Environment.isJavawsAppletLifecycle() ? "javaws applet" : "plugin2";
            } else if (Environment.isJavaWebStart()) {
                string2 = "javaws application";
            }
            if (deploymentRuleSet.isRuleBlock()) {
                string2 = string2 + " denied";
                if (deploymentRuleSet.getBlockString() != null) {
                    string2 = string2 + " [" + deploymentRuleSet.getBlockString() + "]";
                }
            } else if (deploymentRuleSet.isRuleRun()) {
                objectArray = deploymentRuleSet.getVersionString();
                string2 = objectArray == null || SecureStaticVersioning.satisfiesDRSVersion((String)objectArray) ? string2 + " permitted" : string2 + " denied [required version " + (String)objectArray + " not available]";
            }
            objectArray = new Object[]{string2, string};
            this.runMethod.invoke(this.usageTracker, objectArray);
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

