/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.finder.BeanInfoFinder;
import com.sun.beans.finder.PropertyEditorFinder;
import java.awt.GraphicsEnvironment;
import java.beans.BeanInfo;
import java.beans.WeakIdentityMap;
import java.util.Map;
import java.util.WeakHashMap;

final class ThreadGroupContext {
    private static final WeakIdentityMap<ThreadGroupContext> contexts = new WeakIdentityMap();
    private volatile boolean isDesignTime;
    private volatile Boolean isGuiAvailable;
    private Map<Class<?>, BeanInfo> beanInfoCache;
    private BeanInfoFinder beanInfoFinder;
    private PropertyEditorFinder propertyEditorFinder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadGroupContext getContext() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        WeakIdentityMap<ThreadGroupContext> weakIdentityMap = contexts;
        synchronized (weakIdentityMap) {
            ThreadGroupContext threadGroupContext = contexts.get(threadGroup);
            if (threadGroupContext == null) {
                threadGroupContext = new ThreadGroupContext();
                contexts.put(threadGroup, threadGroupContext);
            }
            return threadGroupContext;
        }
    }

    private ThreadGroupContext() {
    }

    boolean isDesignTime() {
        return this.isDesignTime;
    }

    void setDesignTime(boolean bl) {
        this.isDesignTime = bl;
    }

    boolean isGuiAvailable() {
        Boolean bl = this.isGuiAvailable;
        return bl != null ? bl : !GraphicsEnvironment.isHeadless();
    }

    void setGuiAvailable(boolean bl) {
        this.isGuiAvailable = bl;
    }

    BeanInfo getBeanInfo(Class<?> clazz) {
        return this.beanInfoCache != null ? this.beanInfoCache.get(clazz) : null;
    }

    BeanInfo putBeanInfo(Class<?> clazz, BeanInfo beanInfo) {
        if (this.beanInfoCache == null) {
            this.beanInfoCache = new WeakHashMap();
        }
        return this.beanInfoCache.put(clazz, beanInfo);
    }

    void removeBeanInfo(Class<?> clazz) {
        if (this.beanInfoCache != null) {
            this.beanInfoCache.remove(clazz);
        }
    }

    void clearBeanInfoCache() {
        if (this.beanInfoCache != null) {
            this.beanInfoCache.clear();
        }
    }

    synchronized BeanInfoFinder getBeanInfoFinder() {
        if (this.beanInfoFinder == null) {
            this.beanInfoFinder = new BeanInfoFinder();
        }
        return this.beanInfoFinder;
    }

    synchronized PropertyEditorFinder getPropertyEditorFinder() {
        if (this.propertyEditorFinder == null) {
            this.propertyEditorFinder = new PropertyEditorFinder();
        }
        return this.propertyEditorFinder;
    }
}

