/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.util.CompletedFuture;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;

public final class AsyncResponseImpl<T>
extends FutureTask<T>
implements Response<T>,
ResponseContextReceiver {
    private final AsyncHandler<T> handler;
    private ResponseContext responseContext;
    private final Runnable callable;

    public AsyncResponseImpl(Runnable runnable, @Nullable AsyncHandler<T> asyncHandler) {
        super(runnable, null);
        this.callable = runnable;
        this.handler = asyncHandler;
    }

    @Override
    public void run() {
        try {
            this.callable.run();
        }
        catch (WebServiceException webServiceException) {
            this.set(null, webServiceException);
        }
        catch (Throwable throwable) {
            this.set(null, new WebServiceException(throwable));
        }
    }

    public ResponseContext getContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    public void set(T t, Throwable throwable) {
        if (this.handler != null) {
            try {
                class CallbackFuture<T>
                extends CompletedFuture<T>
                implements Response<T> {
                    public CallbackFuture(T t, Throwable throwable) {
                        super(t, throwable);
                    }

                    @Override
                    public Map<String, Object> getContext() {
                        return AsyncResponseImpl.this.getContext();
                    }
                }
                this.handler.handleResponse(new CallbackFuture<T>(t, throwable));
            }
            catch (Throwable throwable2) {
                super.setException(throwable2);
                return;
            }
        }
        if (throwable != null) {
            super.setException(throwable);
        } else {
            super.set(t);
        }
    }
}

