/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.io.IOException;
import java.io.OutputStream;

public class UnsyncBufferedOutputStream
extends OutputStream {
    final OutputStream out;
    final byte[] buf = (byte[])bufCahce.get();
    static final int size = 8192;
    private static ThreadLocal bufCahce = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[8192];
        }
    };
    int pointer = 0;

    public UnsyncBufferedOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pointer + n2;
        if (n3 > 8192) {
            this.flushBuffer();
            if (n2 > 8192) {
                this.out.write(byArray, n, n2);
                return;
            }
            n3 = n2;
        }
        System.arraycopy(byArray, n, this.buf, this.pointer, n2);
        this.pointer = n3;
    }

    private final void flushBuffer() throws IOException {
        if (this.pointer > 0) {
            this.out.write(this.buf, 0, this.pointer);
        }
        this.pointer = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.pointer >= 8192) {
            this.flushBuffer();
        }
        this.buf[this.pointer++] = (byte)n;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

