/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.util.SecuritySupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private PathEntry[] paths;
    private String class_path;

    public ClassPath(String string) {
        this.class_path = string;
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SecuritySupport.getSystemProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!SecuritySupport.getFileExists(file)) continue;
                if (file.isDirectory()) {
                    arrayList.add(new Dir(string2));
                    continue;
                }
                arrayList.add(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[arrayList.size()];
        arrayList.toArray(this.paths);
    }

    public ClassPath() {
        this("");
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)object).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String string, ArrayList arrayList) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!SecuritySupport.getFileExists(file)) continue;
                arrayList.add(string2);
            }
        }
    }

    public static final String getClassPath() {
        Object object;
        String string;
        String string2;
        String string3;
        try {
            string3 = SecuritySupport.getSystemProperty("java.class.path");
            string2 = SecuritySupport.getSystemProperty("sun.boot.class.path");
            string = SecuritySupport.getSystemProperty("java.ext.dirs");
        }
        catch (SecurityException securityException) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPath.getPathComponents(string3, arrayList);
        ClassPath.getPathComponents(string2, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ClassPath.getPathComponents(string, arrayList2);
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = new File((String)object2.next());
            String[] stringArray = SecuritySupport.getFileList((File)object, new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(string + File.separatorChar + stringArray[i]);
            }
        }
        object2 = new StringBuffer();
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)object2).toString().intern();
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(string, string2).getInputStream();
    }

    public ClassFile getClassFile(String string, String string2) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            ClassFile classFile = this.paths[i].getClassFile(string, string2);
            if (classFile == null) continue;
            return classFile;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public ClassFile getClassFile(String string) throws IOException {
        return this.getClassFile(string, ".class");
    }

    public byte[] getBytes(String string, String string2) throws IOException {
        InputStream inputStream = this.getInputStream(string, string2);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string) throws IOException {
        return this.getBytes(string, ".class");
    }

    public String getPath(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getPath();
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string) {
            this.dir = string;
        }

        @Override
        ClassFile getClassFile(String string, String string2) throws IOException {
            final File file = new File(this.dir + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return SecuritySupport.getFileExists(file) ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        @Override
        ClassFile getClassFile(String string, String string2) throws IOException {
            final ZipEntry zipEntry = this.zip.getEntry(string.replace('.', '/') + string2);
            return zipEntry != null ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(zipEntry);
                }

                @Override
                public String getPath() {
                    return zipEntry.toString();
                }

                @Override
                public long getTime() {
                    return zipEntry.getTime();
                }

                @Override
                public long getSize() {
                    return zipEntry.getSize();
                }

                @Override
                public String getBase() {
                    return Zip.this.zip.getName();
                }
            } : null;
        }
    }
}

