/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.transform.Transform;

public class Scale
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty z;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;
    private DoubleProperty pivotZ;

    public Scale() {
    }

    public Scale(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public Scale(double d, double d2, double d3, double d4) {
        this(d, d2);
        this.setPivotX(d3);
        this.setPivotY(d4);
    }

    public Scale(double d, double d2, double d3) {
        this(d, d2);
        this.setZ(d3);
    }

    public Scale(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d4, d5);
        this.setZ(d3);
        this.setPivotZ(d6);
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 1.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 1.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setZ(double d) {
        this.zProperty().set(d);
    }

    public final double getZ() {
        return this.z == null ? 1.0 : this.z.get();
    }

    public final DoubleProperty zProperty() {
        if (this.z == null) {
            this.z = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "z";
                }
            };
        }
        return this.z;
    }

    public final void setPivotX(double d) {
        this.pivotXProperty().set(d);
    }

    public final double getPivotX() {
        return this.pivotX == null ? 0.0 : this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "pivotX";
                }
            };
        }
        return this.pivotX;
    }

    public final void setPivotY(double d) {
        this.pivotYProperty().set(d);
    }

    public final double getPivotY() {
        return this.pivotY == null ? 0.0 : this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "pivotY";
                }
            };
        }
        return this.pivotY;
    }

    public final void setPivotZ(double d) {
        this.pivotZProperty().set(d);
    }

    public final double getPivotZ() {
        return this.pivotZ == null ? 0.0 : this.pivotZ.get();
    }

    public final DoubleProperty pivotZProperty() {
        if (this.pivotZ == null) {
            this.pivotZ = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Scale.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Scale.this;
                }

                @Override
                public String getName() {
                    return "pivotZ";
                }
            };
        }
        return this.pivotZ;
    }

    @Override
    public double getMxx() {
        return this.getX();
    }

    @Override
    public double getMyy() {
        return this.getY();
    }

    @Override
    public double getMzz() {
        return this.getZ();
    }

    @Override
    public double getTx() {
        return (1.0 - this.getX()) * this.getPivotX();
    }

    @Override
    public double getTy() {
        return (1.0 - this.getY()) * this.getPivotY();
    }

    @Override
    public double getTz() {
        return (1.0 - this.getZ()) * this.getPivotZ();
    }

    @Override
    @Deprecated
    public void impl_apply(Affine3D affine3D) {
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0 || this.getPivotZ() != 0.0) {
            affine3D.translate(this.getPivotX(), this.getPivotY(), this.getPivotZ());
            affine3D.scale(this.getX(), this.getY(), this.getZ());
            affine3D.translate(-this.getPivotX(), -this.getPivotY(), -this.getPivotZ());
        } else {
            affine3D.scale(this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    @Deprecated
    public Transform impl_copy() {
        return new Scale(this.getX(), this.getY(), this.getZ(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Scale [");
        stringBuilder.append("x=").append(this.getX());
        stringBuilder.append(", y=").append(this.getY());
        stringBuilder.append(", z=").append(this.getZ());
        stringBuilder.append(", pivotX=").append(this.getPivotX());
        stringBuilder.append(", pivotY=").append(this.getPivotY());
        stringBuilder.append(", pivotZ=").append(this.getPivotZ());
        return stringBuilder.append("]").toString();
    }
}

